--- ../.build/_deps/webview-src/cmake/webview.cmake.orig	2025-06-03 18:40:31 UTC
+++ ../.build/_deps/webview-src/cmake/webview.cmake
@@ -8,11 +8,23 @@ macro(webview_find_dependencies)
 macro(webview_find_dependencies)
     if(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
         list(APPEND WEBVIEW_DEPENDENCIES "-framework WebKit" dl)
-    elseif(CMAKE_SYSTEM_NAME STREQUAL "Linux")
+    elseif(CMAKE_SYSTEM_NAME STREQUAL "Windows")
+        if(WEBVIEW_USE_BUILTIN_MSWEBVIEW2)
+            find_package(MSWebView2 QUIET)
+            if(NOT MSWebView2_FOUND)
+                webview_fetch_mswebview2(${WEBVIEW_MSWEBVIEW2_VERSION})
+            endif()
+            find_package(MSWebView2 REQUIRED)
+            if(MSWebView2_FOUND)
+                list(APPEND WEBVIEW_DEPENDENCIES MSWebView2::headers)
+            endif()
+        endif()
+        list(APPEND WEBVIEW_DEPENDENCIES advapi32 ole32 shell32 shlwapi user32 version)
+    else()
         find_package(PkgConfig REQUIRED)
 
         # List of preferred WebkitGTK modules (from most to least preferred)
-        set(WEBVIEW_WEBKITGTK_PREFERRED_API_LIST webkit2gtk-4.1)
+        set(WEBVIEW_WEBKITGTK_PREFERRED_API_LIST webkitgtk-6.0)
         # List of known WebkitGTK modules (from higher to lower version)
         set(WEBVIEW_WEBKITGTK_KNOWN_API_LIST webkitgtk-6.0 webkit2gtk-4.1 webkit2gtk-4.0)

@@ -58,18 +70,6 @@ macro(webview_find_dependencies)
         endif()
 
         list(APPEND WEBVIEW_DEPENDENCIES PkgConfig::WEBVIEW_WEBKITGTK PkgConfig::WEBVIEW_GTK dl)
-    elseif(CMAKE_SYSTEM_NAME STREQUAL "Windows")
-        if(WEBVIEW_USE_BUILTIN_MSWEBVIEW2)
-            find_package(MSWebView2 QUIET)
-            if(NOT MSWebView2_FOUND)
-                webview_fetch_mswebview2(${WEBVIEW_MSWEBVIEW2_VERSION})
-            endif()
-            find_package(MSWebView2 REQUIRED)
-            if(MSWebView2_FOUND)
-                list(APPEND WEBVIEW_DEPENDENCIES MSWebView2::headers)
-            endif()
-        endif()
-        list(APPEND WEBVIEW_DEPENDENCIES advapi32 ole32 shell32 shlwapi user32 version)
     endif()
 endmacro()
 
